#include <bits/stdc++.h>

using namespace std;

int N,Q;
int P[1050000],M[500100],J[500100];
int copyP[1050000];
int bestResultMatrix[1050000][22];


// Sklapamo niz
void custom_merge(int mergedArray[], int left, int mid, int right)
{
    int leftArrayLength = mid - left + 1;
    int rightArrayLength = right - mid;

    int leftArray[leftArrayLength];
    int rightArray[rightArrayLength];

    // Kopiramo levi i desni niz
    for(int i=0;i< leftArrayLength;i++)
    {
        leftArray[i] = mergedArray[left + i];
    }
    for(int i=0;i< rightArrayLength;i++)
    {
        rightArray[i] = mergedArray[mid + 1 + i];
    }

    // Indeksi
    int leftArrayIndex = 0;
    int rightArrayIndex = 0;
    int mergedArrayIndex = left;

    // Spajanje
    int i=0;
    int level = log2(right - left);
    while(leftArrayIndex < leftArrayLength and rightArrayIndex < rightArrayLength)
    {
        if(leftArray[leftArrayIndex] > rightArray[rightArrayIndex])
        {
            mergedArray[mergedArrayIndex] = leftArray[leftArrayIndex];
            bestResultMatrix[leftArray[leftArrayIndex]][level] = i;
            leftArrayIndex++;
        }
        else
        {
            mergedArray[mergedArrayIndex] = rightArray[rightArrayIndex];
            bestResultMatrix[rightArray[rightArrayIndex]][level] = i;
            rightArrayIndex++;
        }
        mergedArrayIndex++;
        i++;
    }

    // Dodajemo ostatak levog niza
    while(leftArrayIndex < leftArrayLength)
    {
        mergedArray[mergedArrayIndex] = leftArray[leftArrayIndex];
        bestResultMatrix[leftArray[leftArrayIndex]][level] = i;
        leftArrayIndex++;
        mergedArrayIndex++;
        i++;
    }

    // Dodajemo ostatak desnog niza
    while(rightArrayIndex < rightArrayLength)
    {
        mergedArray[mergedArrayIndex] = rightArray[rightArrayIndex];
        bestResultMatrix[rightArray[rightArrayIndex]][level] = i;
        rightArrayIndex++;
        mergedArrayIndex++;
        i++;
    }
}

// Delimo niz
void custom_mergeSort(int Array[], int left, int right)
{
    // Kraj rekurzije
    if(left >= right)
    {
        return;
    }

    // Delimo niz na pola
    int mid = left + (right - left) / 2;
    custom_mergeSort(Array, left, mid);
    custom_mergeSort(Array, mid+1, right);

    // Sklapamo niz
    custom_merge(Array,left,mid,right);
}


// Pravi matricu gde je prvi broj indeks takmicara,
// a drugi broj broj promena potrebnih da takmicar
// dodje do j-tog kruga
void make_bestResultMatrix()
{
    custom_mergeSort(P, 0, N-1);
}

int main()
{
    // Ulaz
    cin>>N;
    for(int i=0;i<N;i++)
    {
        cin>>P[i];
        copyP[i] = P[i];
    }
    cin>>Q;
    for(int i=0;i<Q;i++)
    {
        cin>>M[i]>>J[i];
    }

    // Pravimo matricu gde je:
    // i snaga igraca (0) je najveci element
    // j broj premestanja koje treba izvrsiti da bi igrac sa snagom i prosao j+1 -tog kolo
    make_bestResultMatrix();

    // Odgovaramo na zahteve
    for(int i=0;i<Q;i++)
    {
        int power = copyP[M[i]-1];
        int bestResult = log2(power) + 1;
        if(power == N)
        {
            cout<<bestResult<<endl;
            continue;
        }
        else
        {
            for(int j=0;j<bestResult;j++)
            {
                // Ako ne mozemo da predjemo j-ti nivo
                if(J[i] < bestResultMatrix[power][j])
                {
                    cout<<j+1<<endl;
                    break;
                }
                else
                {
                    if(j == bestResult - 1)
                    {
                        cout<<j+1<<endl;
                        break;
                    }
                }
            }
        }
    }

    return 0;
}